use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- 68
IF OBJECT_ID (''VX_trigger_OnUpdatePanelistAttribute'',''TR'') IS NOT NULL
   DROP TRIGGER VX_trigger_OnUpdatePanelistAttribute;
'

declare @PanelClientPayload02 nvarchar(max) = N'
CREATE TRIGGER VX_trigger_OnUpdatePanelistAttribute
ON [PanelistAttributes]
AFTER UPDATE 
AS
	INSERT INTO [PanelistAttributeModifLogs] ([PanelistId], [AttributeId], [OldValue], [NewValue], [ModificationDateTime], [ModifiedBy])
	SELECT i.[PanelistId], i.[AttributeDefinitionId], d.[Value], i.[Value], GETUTCDATE(), i.[ModifiedBy]
	FROM inserted i 
	INNER JOIN deleted d ON i.[PanelistId] = d.[PanelistId] AND i.[AttributeDefinitionId] = d.[AttributeDefinitionId]
	INNER JOIN [AttributeDefinitions] ad ON i.[AttributeDefinitionId] = ad.Id
	INNER JOIN [Panels] p ON ad.[PanelId] = p.[Id]
	WHERE (d.[Value] is null or d.[Value] != i.[Value]) AND p.[EnableModificationTracking] = 1
'

declare @PanelClientPayload03 nvarchar(max) = N'
IF OBJECT_ID (''VX_trigger_OnInsertPanelistAttribute'',''TR'') IS NOT NULL
   DROP TRIGGER VX_trigger_OnInsertPanelistAttribute;
'

declare @PanelClientPayload04 nvarchar(max) = N'
CREATE TRIGGER VX_trigger_OnInsertPanelistAttribute
ON [PanelistAttributes]
AFTER INSERT 
AS
	INSERT INTO [PanelistAttributeModifLogs] ([PanelistId], [AttributeId], [OldValue], [NewValue], [ModificationDateTime], [ModifiedBy])
	SELECT i.[PanelistId], i.[AttributeDefinitionId], null, i.[Value], GETUTCDATE(), i.[ModifiedBy]
	FROM inserted i
	INNER JOIN [AttributeDefinitions] ad ON i.[AttributeDefinitionId] = ad.Id
	INNER JOIN [Panels] p ON ad.[PanelId] = p.[Id]
	WHERE p.[EnableModificationTracking] = 1
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		print 'Panel Client Payload 1'
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 2'
		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 3'
		select @SQL = replace(replace(@PanelClientPayload03, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 4'
		select @SQL = replace(replace(@PanelClientPayload04, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Panel Client Payload done for panel client ' + @ThisPanelClient + '!'

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
